local function LogoPath(file) return THEME:GetPathG("ScreenTitleMenu","Logo/"..file) end

local function MakeMainCredit(name,role)
	return Def.ActorFrame{
		LoadFont("_francophilsans Bold 24px")..{
			Text=name;
			InitCommand=cmd(x,-(SCREEN_CENTER_X/2);y,-12;halign,0;shadowlength,1);
		};
		LoadFont("_dejavu sans normal 24px")..{
			Text=role;
			InitCommand=cmd(x,-(SCREEN_CENTER_X/2)+16;y,8;zoom,18/24;align,0,0;shadowlength,1);
		};
	}
end

local function MakeSectionHeader(text,tColor)
	if not tColor then
		tColor = color("#FF8800FF")
	end
	return Def.ActorFrame{
		LoadFont("_francophilsans Bold 24px")..{
			Text=text;
			InitCommand=cmd(shadowlength,1;diffuse,tColor);
		};
	}
end

local function MakeSecondaryCredit(name)
	return Def.ActorFrame{
		LoadFont("_dejavu sans normal 24px")..{
			Text=name;
			InitCommand=cmd(zoom,18/24;shadowlength,1);
		};
	}
end

local function BlankLine() return Def.ActorFrame{} end

local item_padding_start = 5;
local CreditScroller = Def.ActorScroller {
	SecondsPerItem = 2;
	NumItemsToDraw = 40;
	TransformFunction = function( self, offset, itemIndex, numItems)
		self:y(96*offset)
	end;
	OnCommand=cmd(scrollwithpadding,item_padding_start,15);
}

table.insert( CreditScroller, MakeMainCredit("freem","Executive Producer, Code, Theme, Graphics") )
table.insert( CreditScroller, MakeMainCredit("phantom","Linux version maintainer, Bugtesting, Support") )
table.insert( CreditScroller, MakeMainCredit("hanubeki","Code from hanumod fork of StepMania 5") )
table.insert( CreditScroller, MakeMainCredit("Ultracat","Background Music ('Disco High');\nLicensed under a Creative Commons\nAttribution License") )
local thanksSpacing = 24
local SpecialThanks = Def.ActorFrame{
	MakeSectionHeader("Special Thanks")..{ InitCommand=cmd(y,thanksSpacing*0;); };
	MakeSecondaryCredit("NAKET Coder")..{ InitCommand=cmd(y,thanksSpacing*1;); };
	MakeSecondaryCredit("phantom")..{ InitCommand=cmd(y,thanksSpacing*2;); };
	MakeSecondaryCredit("Staiain")..{ InitCommand=cmd(y,thanksSpacing*3;); };
	MakeSecondaryCredit("Jousway")..{ InitCommand=cmd(y,thanksSpacing*4;); };
	MakeSecondaryCredit("Hanubeki")..{ InitCommand=cmd(y,thanksSpacing*5;); };
	MakeSecondaryCredit("Wiz Khalifa")..{ InitCommand=cmd(y,thanksSpacing*6;); };
	MakeSecondaryCredit("Juicy J")..{ InitCommand=cmd(y,thanksSpacing*7;); };
	MakeSecondaryCredit("telo")..{ InitCommand=cmd(y,thanksSpacing*8;); };
	MakeSecondaryCredit("Marijuana Dubois")..{ InitCommand=cmd(y,thanksSpacing*9;); };
};
table.insert( CreditScroller, SpecialThanks )

return Def.ActorFrame{
	OnCommand=function(self)
		local topScreen = SCREENMAN:GetTopScreen()
		if topScreen then
			topScreen:PostScreenMessage( "SM_BeginFadingOut", ((#CreditScroller + item_padding_start)+5) );
		end
	end;

	Def.ActorFrame{
		Name="Logo";
		InitCommand=cmd(Center);

		LoadActor(LogoPath("_stepmania"))..{
			Name="SM";
			InitCommand=cmd(x,-56;y,-8;addx,-SCREEN_WIDTH);
			OnCommand=cmd(sleep,1;decelerate,1;addx,SCREEN_WIDTH;sleep,5;playcommand,"Move");
			MoveCommand=cmd(linear,5;addy,-SCREEN_HEIGHT);
		};
		LoadActor(LogoPath("_5"))..{
			Name="Five";
			InitCommand=cmd(x,200;addx,SCREEN_WIDTH);
			OnCommand=cmd(sleep,2;decelerate,1;addx,-SCREEN_WIDTH;sleep,4;playcommand,"Move");
			MoveCommand=cmd(linear,5;addy,-SCREEN_HEIGHT);
		};
		LoadActor(LogoPath("_te main"))..{
			Name="TE";
			InitCommand=cmd(x,0;y,28;diffusealpha,0);
			OnCommand=cmd(sleep,3;accelerate,1;diffusealpha,1;glow,color("#FFFFFFFF");decelerate,1;glow,color("#FFFFFF00");sleep,2;playcommand,"Move");
			MoveCommand=cmd(linear,5;addy,-SCREEN_HEIGHT);
		};
	};

	-- todo: credits scroller time.
	CreditScroller..{
		InitCommand=cmd(CenterX;y,SCREEN_BOTTOM-64);
	};
};